/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import java.util.function.Supplier;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.function.LibFunction;

public class RegisteredFunction {
    private final String name;
    private final Supplier<LibFunction> factory;

    private RegisteredFunction(String name, Supplier<LibFunction> factory) {
        this.name = name;
        this.factory = factory;
    }

    public LibFunction create() {
        LibFunction function = this.factory.get();
        function.name = this.name;
        return function;
    }

    public static LuaTable bind(RegisteredFunction[] functions) {
        LuaTable table = new LuaTable(0, functions.length);
        RegisteredFunction.bind(table, functions);
        return table;
    }

    public static void bind(LuaTable table, RegisteredFunction[] functions) {
        for (RegisteredFunction def : functions) {
            table.rawset(def.name, (LuaValue)def.create());
        }
    }

    public static RegisteredFunction ofFactory(String name, Supplier<LibFunction> fn) {
        return new RegisteredFunction(name, fn);
    }

    public static RegisteredFunction of(String name, LibFunction.ZeroArg fn) {
        return new RegisteredFunction(name, () -> LibFunction.create(fn));
    }

    public static RegisteredFunction of(String name, LibFunction.OneArg fn) {
        return new RegisteredFunction(name, () -> LibFunction.create(fn));
    }

    public static RegisteredFunction of(String name, LibFunction.TwoArg fn) {
        return new RegisteredFunction(name, () -> LibFunction.create(fn));
    }

    public static RegisteredFunction of(String name, LibFunction.ThreeArg fn) {
        return new RegisteredFunction(name, () -> LibFunction.create(fn));
    }

    public static RegisteredFunction ofV(String name, LibFunction.ManyArgs fn) {
        return new RegisteredFunction(name, () -> LibFunction.createV(fn));
    }

    public static RegisteredFunction ofS(String name, LibFunction.Suspended fn) {
        return new RegisteredFunction(name, () -> LibFunction.createS(fn));
    }
}

